import { fileURLToPath, URL } from 'node:url'
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueDevTools from 'vite-plugin-vue-devtools'
import cesium from 'vite-plugin-cesium'
import { visualizer } from 'rollup-plugin-visualizer' // 新增：打包分析工具

export default defineConfig({
  plugins: [
    vue(),
    vueDevTools(),
    cesium(),
    visualizer({ open: true }) // 打包后自动显示分析报告
  ],
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    }
  },
  build: {
    rollupOptions: {
      output: {
        manualChunks(id) {
          // 将大依赖拆分成单独 chunk
            if (id.includes('vue')) return 'vendor-vue'
            if (id.includes('cesium')) return 'vendor-cesium'
            return 'vendor'

        }
      }
    },
    chunkSizeWarningLimit: 1000 // 提高警告阈值到 1000KB
  },
  server: {
    proxy: {
      '/api': {
        target: 'http://localhost:8000',
        changeOrigin: true,
        rewrite: path => path.replace(/^\/api/, '')
      }
    }
  }
})