import { createRouter, createWebHistory } from 'vue-router'

// 使用动态导入（按需加载）
const routes = [
  {
    path: '/',
    name: 'Home',
    component: () => import('../views/Home.vue')
  },
  {
    path: '/intro',
    name: 'Intro',
    component: () => import('../views/Intro.vue')
  },
  {
    path: '/location',
    name: 'Locate',
    component: () => import('../views/Location.vue')
  },
  {
    path: '/visit',
    name: 'Visit',
    component: () => import('../views/Visit.vue')
  },
  {
    path: '/traffic',
    name: 'Traffic',
    component: () => import('../views/Traffic.vue')
  },
  {
    path: '/industry',
    name: 'Industry',
    component: () => import('../views/Industry.vue')
  },
  {
    path: '/policy',
    name: 'Policy',
    component: () => import('../views/Policy.vue')
  },
  {
    path: '/chat',
    name: 'Chat',
    component: () => import('../views/ChatEmbed.vue')
  },
  {
    path: '/chat-original',
    name: 'ChatOriginal',
    component: () => import('../views/Chat.vue')
  }
]

const router = createRouter({
  history: createWebHistory(),
  routes,
  // 可选：滚动行为控制
  scrollBehavior(to, from, savedPosition) {
    return savedPosition || { top: 0 }
  }
})

export default router