from flask import Flask, request, jsonify
from flask_cors import CORS
from db import get_connection
import psycopg2

app = Flask(__name__)
CORS(app)

@app.route("/api/visit/personal", methods=["POST"])
def handle_personal_visit():
    data = request.json
    required = ["name", "phone", "purpose", "visitDate", "visitTime"]
    if not all(field in data and data[field] for field in required):
        return jsonify({"success": False, "message": "缺少字段"}), 400

    try:
        conn = get_connection()
        cur = conn.cursor()
        cur.execute("""
            INSERT INTO personal_visits (name, phone, purpose, visit_date, visit_time)
            VALUES (%s, %s, %s, %s, %s)
        """, (data["name"], data["phone"], data["purpose"], data["visitDate"], data["visitTime"]))
        conn.commit()
        cur.close()
        conn.close()
        return jsonify({"success": True, "message": "提交成功"})
    except psycopg2.Error as e:
        return jsonify({"success": False, "message": "数据库错误", "error": str(e)}), 500


@app.route("/api/visit/company", methods=["POST"])
def handle_company_visit():
    data = request.json
    required = [
        "companyName", "contactName", "contactPosition",
        "phone", "purpose", "cooperationIntention", "visitDate", "visitTime"
    ]
    if not all(field in data and data[field] for field in required):
        return jsonify({"success": False, "message": "缺少字段"}), 400

    try:
        conn = get_connection()
        cur = conn.cursor()
        cur.execute("""
            INSERT INTO company_visits 
            (company_name, contact_name, contact_position, phone, purpose, cooperation_intention, visit_date, visit_time)
            VALUES (%s, %s, %s, %s, %s, %s, %s, %s)
        """, (
            data["companyName"], data["contactName"], data["contactPosition"],
            data["phone"], data["purpose"], data["cooperationIntention"],
            data["visitDate"], data["visitTime"]
        ))
        conn.commit()
        cur.close()
        conn.close()
        return jsonify({"success": True, "message": "企业预约提交成功"})
    except psycopg2.Error as e:
        return jsonify({"success": False, "message": "数据库错误", "error": str(e)}), 500


if __name__ == "__main__":
    app.run(host="127.0.0.1", port=8000)